<?php
session_start();
include '../config/db.php';
include '../includes/header.php';
include '../includes/navbar.php';

$user = $_SESSION['user'] ?? null;
if (!$user || $user['role'] !== 'admin') {
    header("Location: ../public/login.php");
    exit();
}

// Statistik laporan
$pending = 0; $disetujui = 0; $ditolak = 0;
if ($conn) {
    $result1 = mysqli_query($conn, "SELECT COUNT(*) FROM laporan WHERE status = 'pending'");
    if ($result1) $pending = mysqli_fetch_row($result1)[0];

    $result2 = mysqli_query($conn, "SELECT COUNT(*) FROM laporan WHERE status = 'disetujui'");
    if ($result2) $disetujui = mysqli_fetch_row($result2)[0];

    $result3 = mysqli_query($conn, "SELECT COUNT(*) FROM laporan WHERE status = 'ditolak'");
    if ($result3) $ditolak = mysqli_fetch_row($result3)[0];
}

// Data daftar laporan
$laporan = [];
$status = $_GET['status'] ?? 'pending';
if ($conn) {
    $stmt = mysqli_prepare($conn, "SELECT * FROM laporan WHERE status = ? ORDER BY tanggal DESC");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $status);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        while ($row = mysqli_fetch_assoc($result)) {
            $laporan[] = $row;
        }
        mysqli_stmt_close($stmt);
    }
}
?>

<<div class="container mt-4">
    <!-- HEADER USER DIAWAL -->
    <div class="d-flex justify-content-end align-items-center mb-3">
        <!-- ... bagian user dan logout ... -->
    </div>
    <!-- END HEADER USER -->

    <!-- Tambahkan di sini -->
    <div class="d-flex justify-content-end align-items-center mb-3">
        <a href="data_karyawan.php" class="btn btn-primary">
            <!-- Icon plus person -->
            <!-- ... (SVG code as shown above) ... -->
            Input Data Karyawan
        </a>
    </div>

    <h4>Admin Dashboard - Approval Laporan</h4>
    <p>Kelola dan setujui laporan insiden yang masuk</p>

    <!-- ... Card Statistik dan seterusnya ... -->
    <!-- Card Statistik -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card text-center border-warning">
                <div class="card-body">
                    <h6>Menunggu Persetujuan</h6>
                    <h2><?= $pending ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-center border-success">
                <div class="card-body">
                    <h6>Disetujui</h6>
                    <h2><?= $disetujui ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-center border-danger">
                <div class="card-body">
                    <h6>Ditolak</h6>
                    <h2><?= $ditolak ?></h2>
                </div>
            </div>
        </div>
    </div>

    <!-- Daftar Laporan -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <ul class="nav nav-tabs card-header-tabs" id="laporanTab">
                <li class="nav-item">
                    <a class="nav-link <?= $status == 'pending' ? 'active' : '' ?>" href="?status=pending">Pending (<?= $pending ?>)</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $status == 'disetujui' ? 'active' : '' ?>" href="?status=disetujui">Disetujui (<?= $disetujui ?>)</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= $status == 'ditolak' ? 'active' : '' ?>" href="?status=ditolak">Ditolak (<?= $ditolak ?>)</a>
                </li>
            </ul>
            <div>
                <button class="btn btn-outline-secondary btn-sm">Filter</button>
                <button class="btn btn-outline-primary btn-sm">Export</button>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Tanggal</th>
                        <th>Pelapor</th>
                        <th>Dept</th>
                        <th>Jenis</th>
                        <th>Tingkat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($laporan): ?>
                        <?php foreach ($laporan as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['kode_laporan']) ?></td>
                                <td><?= date('d M Y', strtotime($row['tanggal'])) ?></td>
                                <td><?= htmlspecialchars($row['pelapor']) ?></td>
                                <td><?= htmlspecialchars($row['departemen']) ?></td>
                                <td><?= htmlspecialchars($row['jenis_insiden']) ?></td>
                                <td>
                                    <?php if ($row['tingkat'] == 'Tinggi'): ?>
                                        <span class="badge bg-danger">Tinggi</span>
                                    <?php elseif ($row['tingkat'] == 'Sedang'): ?>
                                        <span class="badge bg-warning text-dark">Sedang</span>
                                    <?php else: ?>
                                        <span class="badge bg-success">Rendah</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="detail.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-dark">Detail</a>
                                    <a href="approve.php?id=<?= $row['id'] ?>&action=setuju" class="btn btn-sm btn-success">Setuju</a>
                                    <a href="approve.php?id=<?= $row['id'] ?>&action=tolak" class="btn btn-sm btn-danger">Tolak</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="7" class="text-center">Tidak ada laporan</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>