CREATE DATABASE angels_products;

USE angels_products;

-- Table Users
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100),
    username VARCHAR(50) UNIQUE,
    password VARCHAR(255),
    role ENUM('admin', 'petugas', 'supervisor'),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Table Laporan Insiden
CREATE TABLE laporan (
    id INT AUTO_INCREMENT PRIMARY KEY,
    judul VARCHAR(255),
    deskripsi TEXT,
    lokasi VARCHAR(100),
    tanggal DATE,
    jam TIME,
    korban VARCHAR(100),
    status ENUM('baru', 'proses', 'selesai', 'disetujui') DEFAULT 'baru',
    pelapor_id INT,
    file_excel VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (pelapor_id) REFERENCES users(id)
);

-- Table Statistik
CREATE TABLE statistik (
    id INT AUTO_INCREMENT PRIMARY KEY,
    bulan VARCHAR(20),
    tahun INT,
    total_insiden INT,
    insiden_selesai INT,
    pekerja_terlatih INT,
    tingkat_kecelakaan FLOAT
);

-- Table Panduan K3
CREATE TABLE panduan (
    id INT AUTO_INCREMENT PRIMARY KEY,
    judul VARCHAR(255),
    isi TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Table Settings
CREATE TABLE settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    logo VARCHAR(255),
    footer TEXT,
    alamat_pt TEXT
);