<?php
include '../config/db.php';

$id = $_GET['id'] ?? 0;
$query = mysqli_query($conn, "SELECT * FROM laporan_insiden WHERE id = '$id'");
$data = mysqli_fetch_assoc($query);

if (!$data) {
    echo "<p>Data tidak ditemukan.</p>";
    exit;
}
?>

<div class="container">
    <p class="text-muted">Informasi lengkap laporan insiden</p>
    <div class="row mb-3">
        <div class="col-md-6">
            <strong>ID Laporan</strong><br><?= $data['kode_insiden'] ?>
        </div>
        <div class="col-md-6">
            <strong>Tanggal Kejadian</strong><br><?= date('d M Y', strtotime($data['tanggal'])) ?>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <strong>Pelapor</strong><br><?= htmlspecialchars($data['pelapor']) ?>
        </div>
        <div class="col-md-6">
            <strong>Departemen</strong><br><?= htmlspecialchars($data['departemen']) ?>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <strong>Jenis Insiden</strong><br><?= htmlspecialchars($data['jenis_insiden']) ?>
        </div>
        <div class="col-md-6">
            <strong>Lokasi</strong><br><?= htmlspecialchars($data['lokasi']) ?>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <strong>Tingkat Keparahan</strong><br>
            <?php
            $tingkat = strtolower($data['tingkat_risiko']);
            if ($tingkat == 'rendah') echo '<span class="badge bg-success">Rendah</span>';
            elseif ($tingkat == 'sedang') echo '<span class="badge bg-warning text-dark">Sedang</span>';
            else echo '<span class="badge bg-danger">Tinggi</span>';
            ?>
        </div>
        <div class="col-md-6">
            <strong>Status</strong><br>
            <?php
            if ($data['status'] == 'Perlu Investigasi')
                echo '<span class="badge bg-primary">Perlu Investigasi</span>';
            elseif ($data['status'] == 'Dalam Proses')
                echo '<span class="badge bg-warning text-dark">Dalam Proses</span>';
            else
                echo '<span class="badge bg-success">Selesai</span>';
            ?>
        </div>
    </div>

    <div class="mb-3">
        <strong>Deskripsi Kejadian</strong>
        <div class="border rounded p-2 bg-light mt-1">
            <?= nl2br(htmlspecialchars($data['deskripsi'])) ?>
        </div>
    </div>

    <div class="mb-3">
        <strong>Tindakan yang Dilakukan</strong>
        <div class="border rounded p-2 bg-light mt-1">
            <?= nl2br(htmlspecialchars($data['tindakan'])) ?>
        </div>
    </div>
</div>