<?php
include '../config/db.php';

$id = $_GET['id'] ?? 0;
$query = mysqli_query($conn, "SELECT * FROM laporan_insiden WHERE id = '$id'");
$data = mysqli_fetch_assoc($query);

if (!$data) {
    echo "<p>Data tidak ditemukan.</p>";
    exit;
}
?>

<form id="formInvestigasi">
    <input type="hidden" name="id" value="<?= $data['id'] ?>">

    <p class="text-muted">Tambahkan hasil investigasi dan ubah status laporan</p>

    <div class="border rounded p-3 bg-light mb-3">
        <strong>ID Laporan:</strong> <?= $data['kode_insiden'] ?><br>
        <strong>Pelapor:</strong> <?= htmlspecialchars($data['pelapor']) ?> - <?= htmlspecialchars($data['departemen']) ?><br>
        <strong>Jenis Insiden:</strong> <?= htmlspecialchars($data['jenis_insiden']) ?>
    </div>

    <div class="mb-3">
        <label class="form-label"><strong>Status Laporan</strong></label>
        <select name="status" class="form-select" required>
            <option value="Perlu Investigasi" <?= $data['status'] == 'Perlu Investigasi' ? 'selected' : '' ?>>Perlu Investigasi</option>
            <option value="Dalam Proses" <?= $data['status'] == 'Dalam Proses' ? 'selected' : '' ?>>Dalam Proses</option>
            <option value="Selesai" <?= $data['status'] == 'Selesai' ? 'selected' : '' ?>>Selesai</option>
        </select>
    </div>

    <div class="mb-3">
        <label class="form-label"><strong>Hasil Investigasi</strong></label>
        <textarea name="hasil_investigasi" class="form-control" rows="4" placeholder="Masukkan hasil investigasi, temuan, rekomendasi, dan tindak lanjut yang diperlukan..." required><?= htmlspecialchars($data['hasil_investigasi'] ?? '') ?></textarea>
    </div>

    <div class="text-end">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <button type="submit" class="btn btn-primary">Simpan & Update Status</button>
    </div>
</form>

<script>
document.getElementById('formInvestigasi').addEventListener('submit', function(e) {
    e.preventDefault();
    const formData = new FormData(this);

    fetch('update_investigasi.php', {
        method: 'POST',
        body: formData
    })
    .then(res => res.text())
    .then(resp => {
        alert(resp);
        location.reload(); // refresh dashboard
    });
});
</script>
