<?php
session_start();
include '../config/db.php';
include '../includes/header.php';
include '../includes/navbar.php';

$user = $_SESSION['user'] ?? null;
if (!$user || $user['role'] !== 'petugas') {
    header("Location: ../public/login.php");
    exit();
}

// Data daftar laporan
$laporan = [];
$status = $_GET['status'] ?? 'pending';
if ($conn) {
    // Pilih field yang dibutuhkan saja
    $stmt = mysqli_prepare(
        $conn,
        "SELECT id, tanggal, pelapor, departemen, jenis_insiden, tingkat, status FROM laporan WHERE status = ? ORDER BY tanggal DESC"
    );
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $status);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        while ($row = mysqli_fetch_assoc($result)) {
            $laporan[] = $row;
        }
        mysqli_stmt_close($stmt);
    }
}

// Hitung jumlah berdasarkan status
$perluInvestigasi = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM laporan WHERE status = 'Perlu Investigasi'"));
$dalamProses = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM laporan WHERE status = 'Dalam Proses'"));
$selesai = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM laporan WHERE status = 'Selesai'"));

?>

<div class="container mt-4">
    <h4>Dashboard Petugas EHS - Investigasi Laporan</h4>
    <p>Validasi dan investigasi laporan insiden EHS</p>

    <!-- Statistik Ringkas dengan border warna -->
    <div class="row mb-4">
        <div class="col-md-4 mb-2 mb-md-0">
            <div class="card text-center p-3 shadow-sm" style="border:2px solid #ffe28a;">
                <p class="mb-1 fw-bold">Perlu Investigasi</p>
                <h3><?= $perluInvestigasi ?></h3>
            </div>
        </div>
        <div class="col-md-4 mb-2 mb-md-0">
            <div class="card text-center p-3 shadow-sm" style="border:2px solid #9be7c4;">
                <p class="mb-1 fw-bold">Dalam Proses</p>
                <h3><?= $dalamProses ?></h3>
            </div>
        </div>
        <div class="col-md-4 mb-2 mb-md-0">
            <div class="card text-center p-3 shadow-sm" style="border:2px solid #f5b2b0;">
                <p class="mb-1 fw-bold">Selesai</p>
                <h3><?= $selesai ?></h3>
            </div>
        </div>
    </div>

    <!-- Tabel Laporan -->
    <div class="card p-3 shadow-sm">
        <div class="d-flex mb-2">
            <!-- Tabs Status -->
            <nav class="nav nav-tabs border-0 flex-row">
                <a class="nav-link fw-bold <?= (!isset($_GET['tab'])||$_GET['tab']=='investigasi')?'active text-primary':'' ?>" href="#">Perlu Investigasi (<?= $perluInvestigasi ?>)</a>
                <a class="nav-link fw-bold <?= (isset($_GET['tab'])&&$_GET['tab']=='proses')?'active text-primary':'' ?>" href="#">Dalam Proses (<?= $dalamProses ?>)</a>
                <a class="nav-link fw-bold <?= (isset($_GET['tab'])&&$_GET['tab']=='selesai')?'active text-primary':'' ?>" href="#">Selesai (<?= $selesai ?>)</a>
            </nav>
            <!-- Filter & Export Button -->
            <div class="ms-auto d-flex gap-2">
                <button class="btn btn-light border"><i class="bi bi-funnel"></i> Filter</button>
                <button class="btn btn-light border"><i class="bi bi-download"></i> Export</button>
            </div>
        </div>

        <!-- Modal Detail & Investigasi (tetap, tidak diubah) -->

        <!-- Tabel Data -->
        <div class="table-responsive">
            <table class="table align-middle mb-0">
            <thead class="table-light">
                <tr>
                    <th>ID</th>
                    <th>Tanggal</th>
                    <th>Pelapor</th>
                    <th>Dept</th>
                    <th>Jenis</th>
                    <th>Tingkat</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($laporan): ?>
                    <?php foreach ($laporan as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['id']) ?></td>
                            <td><?= date('d M Y', strtotime($row['tanggal'])) ?></td>
                            <td><?= htmlspecialchars($row['pelapor']) ?></td>
                            <td><?= htmlspecialchars($row['departemen']) ?></td>
                            <td><?= htmlspecialchars($row['jenis_insiden']) ?></td>
                            <td>
                                <?php if ($row['tingkat'] == 'Tinggi'): ?>
                                    <span class="badge bg-danger">Tinggi</span>
                                <?php elseif ($row['tingkat'] == 'Sedang'): ?>
                                    <span class="badge bg-warning text-dark">Sedang</span>
                                <?php else: ?>
                                    <span class="badge bg-success">Rendah</span>
                                <?php endif; ?>
                            </td>
                            <td><?= htmlspecialchars($row['status']) ?></td>
                            <td>
                                <a href="detail.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-dark">Detail</a>
                                <a href="approve.php?id=<?= $row['id'] ?>&action=setuju" class="btn btn-sm btn-success">Setuju</a>
                                <a href="approve.php?id=<?= $row['id'] ?>&action=tolak" class="btn btn-sm btn-danger">Tolak</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="8" class="text-center">Tidak ada laporan</td></tr>
                <?php endif; ?>
            </tbody>         
            </table>
        </div>
    </div>
</div>
<?php include '../includes/footer.php'; ?>