<?php
session_start();
if ($_SESSION['role'] != 'petugas') { header("Location: ../public/dashboard.php"); exit; }
include '../includes/header.php';
include '../config/db.php';

// Update status laporan
if (isset($_POST['status']) && isset($_POST['id'])) {
    $status = $_POST['status'];
    $id = $_POST['id'];
    mysqli_query($conn, "UPDATE laporan SET status='$status' WHERE id=$id");
    echo "<div class='msg alert alert-success'>Status laporan diperbarui.</div>";
}

// Status Summary
$perlu_investigasi = mysqli_query($conn, "SELECT COUNT(*) as jml FROM laporan WHERE status='investigasi'");
$proses = mysqli_query($conn, "SELECT COUNT(*) as jml FROM laporan WHERE status='proses'");
$selesai = mysqli_query($conn, "SELECT COUNT(*) as jml FROM laporan WHERE status='selesai'");

$jumlah_investigasi = mysqli_fetch_assoc($perlu_investigasi)['jml'];
$jumlah_proses = mysqli_fetch_assoc($proses)['jml'];
$jumlah_selesai = mysqli_fetch_assoc($selesai)['jml'];

// Tab
$status_tab = isset($_GET['tab']) ? $_GET['tab'] : 'investigasi';

// Query data sesuai tab
$filter_status = [
    'investigasi' => 'Perlu Investigasi',
    'proses' => 'Dalam Proses',
    'selesai' => 'Selesai'
];
$result = mysqli_query($conn, "SELECT * FROM laporan WHERE status='$status_tab' ORDER BY created_at DESC");
?>
<div class="container my-4">
    <h2>Dashboard Petugas K3 - Investigasi Laporan</h2>
    <p>Validasi dan investigasi laporan insiden K3</p>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body d-flex align-items-center">
                    <div>
                        <div class="mb-2 text-muted">Perlu Investigasi</div>
                        <h4><?= $jumlah_investigasi ?></h4>
                    </div>
                    <div class="ms-auto">
                        <span class="bg-primary text-white p-2 rounded"><i class="bi bi-file-earmark-text"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body d-flex align-items-center">
                    <div>
                        <div class="mb-2 text-muted">Dalam Proses</div>
                        <h4><?= $jumlah_proses ?></h4>
                    </div>
                    <div class="ms-auto">
                        <span class="bg-warning text-white p-2 rounded"><i class="bi bi-clock-history"></i></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body d-flex align-items-center">
                    <div>
                        <div class="mb-2 text-muted">Selesai</div>
                        <h4><?= $jumlah_selesai ?></h4>
                    </div>
                    <div class="ms-auto">
                        <span class="bg-success text-white p-2 rounded"><i class="bi bi-check2-circle"></i></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-pills mb-3">
        <?php foreach ($filter_status as $key => $val) : ?>
        <li class="nav-item">
            <a class="nav-link <?= $status_tab == $key ? 'active' : '' ?>" href="?tab=<?= $key ?>">
                <?= $val ?> (<?= ($key == 'investigasi' ? $jumlah_investigasi : ($key == 'proses' ? $jumlah_proses : $jumlah_selesai)) ?>)
            </a>
        </li>
        <?php endforeach; ?>
    </ul>

    <!-- Buttons Filter + Export -->
    <div class="d-flex justify-content-end mb-3">
        <button class="btn btn-outline-secondary me-2"><i class="bi bi-funnel"></i> Filter</button>
        <button class="btn btn-outline-secondary"><i class="bi bi-download"></i> Export</button>
    </div>

    <!-- Table -->
    <div class="table-responsive">
    <table class="table table-bordered align-middle">
        <thead class="table-light">
            <tr>
                <th>ID</th>
                <th>Tanggal</th>
                <th>Pelapor</th>
                <th>Dept</th>
                <th>Jenis</th>
                <th>Tingkat</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = mysqli_fetch_assoc($result)): ?>
            <tr>
                <td><?= htmlspecialchars($row['nomor']) ?></td>
                <td><?= date('d M Y', strtotime($row['tanggal'])) ?></td>
                <td><?= htmlspecialchars($row['pelapor']) ?></td>
                <td><?= htmlspecialchars($row['dept']) ?></td>
                <td><?= htmlspecialchars($row['jenis']) ?></td>
                <td>
                    <?php
                    $tingkat = strtolower($row['tingkat']);
                    if ($tingkat == 'sedang') {
                        echo '<span class="badge bg-warning text-dark">Sedang</span>';
                    } elseif ($tingkat == 'rendah') {
                        echo '<span class="badge bg-success">Rendah</span>';
                    } else {
                        echo '<span class="badge bg-danger">Tinggi</span>';
                    }
                    ?>
                </td>
                <td>
                    <a href="detail.php?id=<?= $row['id'] ?>" class="me-2 text-dark"><i class="bi bi-eye"></i> Detail</a>
                    <a href="investigasi.php?id=<?= $row['id'] ?>" class="text-primary"><i class="bi bi-search"></i> Investigasi</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
    </div>
</div>
<?php include '../includes/footer.php'; ?>