<?php
session_start();
include '../includes/header.php';
include '../includes/navbar.php';
include '../config/db.php';

// Query ringkasan statistik
$sql = "SELECT 
    (SELECT COUNT(*) FROM laporan WHERE MONTH(tanggal)=MONTH(CURDATE()) AND YEAR(tanggal)=YEAR(CURDATE())) AS total_bulan_ini,
    (SELECT COUNT(*) FROM laporan WHERE status='selesai' AND MONTH(tanggal)=MONTH(CURDATE())) AS selesai_bulan_ini,
    (SELECT COUNT(*) FROM users WHERE role='petugas') AS pekerja_terlatih,
    (SELECT ROUND(COUNT(*)/(SELECT COUNT(*) FROM laporan WHERE YEAR(tanggal)=YEAR(CURDATE()))*100,2) FROM laporan WHERE MONTH(tanggal)=MONTH(CURDATE())) AS tingkat_kecelakaan";
$result = mysqli_query($conn, $sql);
$data = mysqli_fetch_assoc($result);
?>

<h2>Statistik Ringkas</h2>
<div class="dashboard-cards">
    <div class="card">Total Insiden Bulan Ini: <?= $data['total_bulan_ini'] ?></div>
    <div class="card">Insiden Terselesaikan: <?= $data['selesai_bulan_ini'] ?></div>
    <div class="card">Pekerja Terlatih K3: <?= $data['pekerja_terlatih'] ?></div>
    <div class="card">Tingkat Kecelakaan: <?= $data['tingkat_kecelakaan'] ?>%</div>
</div>

<?php include '../includes/footer.php'; ?>