<?php
session_start();
include '../includes/header.php';
include '../includes/navbar.php';
include '../config/db.php';

// PROSES SUBMIT FORM
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Ambil semua nilai dari POST
    $jenis_kecelakaan   = $_POST['jenis_kecelakaan'];
    $tingkat            = $_POST['tingkat'];
    $penyebab           = $_POST['penyebab'];
    $kronologi          = $_POST['kronologi'];
    $tanggal            = $_POST['tanggal'];
    $jam                = $_POST['jam'];
    $lokasi             = $_POST['lokasi'];
    $seksi              = $_POST['seksi'];
    $alat_bahan         = $_POST['alat_bahan'];
    $nama_korban        = $_POST['nama_korban'];
    $alamat_korban      = $_POST['alamat_korban'];
    $kelamin            = $_POST['kelamin'];
    $usia               = $_POST['usia'];
    $nrp                = $_POST['nrp'];
    $masa_kerja         = $_POST['masa_kerja'];
    $masa_jabatan       = $_POST['masa_jabatan'];
    $status_korban      = $_POST['status_korban'];
    $masa_kerja_jabatan = $_POST['masa_kerja_jabatan'];
    $pertolongan        = isset($_POST['pertolongan']) ? $_POST['pertolongan'] : '';
    $nik                = isset($_POST['nik']) ? $_POST['nik'] : '';

    // Cek dulu NIK dari dropdown (tabel karyawan)
    $nik_check_query = "SELECT nik FROM karyawan WHERE nik = '$nik'";
    $nik_check_result = mysqli_query($conn, $nik_check_query);

    if (mysqli_num_rows($nik_check_result) == 0) {
        echo "<div style='color:red;'>Error: NIK <b>$nik</b> tidak ditemukan di tabel karyawan. Mohon masukkan NIK yang valid.</div>";
    } else {
        // Upload foto (opsional)
        $foto = '';
        if (!empty($_FILES['foto']['name'])) {
            $target_foto = '../uploads/' . basename($_FILES['foto']['name']);
            if (move_uploaded_file($_FILES['foto']['tmp_name'], $target_foto)) {
                $foto = $_FILES['foto']['name'];
            }
        }

        // Query insert ke database
        $sql = "INSERT INTO laporan (
            jenis_kecelakaan, tingkat, penyebab, kronologi, tanggal, jam, lokasi, seksi, alat_bahan,
            nama_korban, alamat_korban, kelamin, usia, nrp, nik, masa_kerja, masa_jabatan, status_korban, 
            masa_kerja_jabatan, pertolongan, foto
        ) VALUES (
            '$jenis_kecelakaan', '$tingkat', '$penyebab', '$kronologi', '$tanggal', '$jam', '$lokasi', '$seksi', '$alat_bahan',
            '$nama_korban', '$alamat_korban', '$kelamin', '$usia', '$nrp', '$nik', '$masa_kerja', '$masa_jabatan', '$status_korban',
            '$masa_kerja_jabatan', '$pertolongan','$foto'
        )";

        if (mysqli_query($conn, $sql)) {
            echo "<div style='color:green;'>Laporan berhasil dikirim!</div>";
        } else {
            echo "<div style='color:red;'>Error: " . mysqli_error($conn) . "</div>";
        }
    }
}
?>

<div class="form-container">
  <h2 class="form-title">Formulir Pelaporan Insiden Kecelakaan Kerja</h2>
  <hr>
  <form method="POST" enctype="multipart/form-data">
    <form action="proses_laporan.php" method="POST">
  <!-- inputan laporan: tanggal, pelapor, dept, jenis, tingkat, dll -->
  <button type="submit">Submit Laporan</button>
</form>
    <!-- Data Insiden -->
    <div class="form-row">
      <label for="jenis_kecelakaan">Jenis Kecelakaan</label>
      <select name="jenis_kecelakaan" id="jenis_kecelakaan">
        <option value="">Pilih jenis...</option>
        <option value="Industri">Industri</option>
        <option value="Lalu Lintas">Lalu Lintas</option>
        <option value="Lain-lain">Lain-lain</option>
      </select>
    </div>
    <div class="form-row">
      <label for="tingkat">Tingkat Kecelakaan</label>
      <select name="tingkat" id="tingkat">
        <option value="">Pilih tingkat...</option>
        <option value="Minor">Minor</option>
        <option value="Mayor">Mayor</option>
        <option value="Fatal">Fatal</option>
        <option value="Lain-lain">Lain-lain</option>
      </select>
    </div>
    <div class="form-row">
      <label for="penyebab">Penyebab Kecelakaan</label>
      <input type="text" name="penyebab" id="penyebab">
    </div>
    <div class="form-row">
      <label for="kronologi">Kronologi Kejadian</label>
      <textarea name="kronologi" id="kronologi"></textarea>
    </div>
    <div class="form-row">
      <label for="tanggal">Tanggal Kecelakaan</label>
      <input type="date" name="tanggal" id="tanggal" required>
    </div>
    <div class="form-row">
      <label for="jam">Jam Kecelakaan</label>
      <input type="time" name="jam" id="jam">
    </div>
    <div class="form-row">
      <label for="lokasi">Lokasi Kecelakaan</label>
      <input type="text" name="lokasi" id="lokasi" required>
    </div>
    <div class="form-row">
      <label for="seksi">Seksi/Departemen</label>
      <input type="text" name="seksi" id="seksi">
    </div>
    <div class="form-row">
      <label for="alat_bahan">Alat/Bahan Terlibat</label>
      <input type="text" name="alat_bahan" id="alat_bahan">
    </div>
    <div class="form-row">
      <label for="nama_korban">Nama Korban</label>
      <input type="text" name="nama_korban" id="nama_korban">
    </div>
    <div class="form-row">
      <label for="alamat_korban">Alamat Korban</label>
      <input type="text" name="alamat_korban" id="alamat_korban">
    </div>
    <div class="form-row">
      <label for="kelamin">Kelamin</label>
      <select name="kelamin" id="kelamin">
        <option value="">Pilih jenis kelamin...</option>
        <option value="Pria">Pria</option>
        <option value="Wanita">Wanita</option>
      </select>
    </div>
    <div class="form-row">
      <label for="usia">Usia</label>
      <input type="number" name="usia" id="usia" min="16" max="80" placeholder="tahun">
    </div>
    <div class="form-row">
      <label for="nrp">NRP</label>
      <input type="text" name="nrp" id="nrp">
    </div>
    <!-- BAGIAN NIK YANG SUDAH DIPROSES DROPDOWN -->
    <div class="form-row">
      <label for="nik">NIK</label>
      <select name="nik" id="nik" required>
        <option value="">Pilih NIK...</option>
        <?php
        $result = mysqli_query($conn, "SELECT nik, nama FROM karyawan");
        while($row = mysqli_fetch_assoc($result)) {
          echo "<option value='{$row['nik']}'>{$row['nik']} - {$row['nama']}</option>";
        }
        ?>
      </select>
    </div>
    <!-- DATA LANJUTAN -->
    <div class="form-row">
      <label for="masa_kerja">Masa Kerja di Perusahaan</label>
      <input type="number" name="masa_kerja" id="masa_kerja" placeholder="tahun">
    </div>
    <div class="form-row">
      <label for="masa_jabatan">Masa Jabatan</label>
      <input type="number" name="masa_jabatan" id="masa_jabatan" placeholder="tahun">
    </div>
    <div class="form-row">
      <label for="status_korban">Status Korban</label>
      <select name="status_korban" id="status_korban">
        <option value="">Pilih status korban...</option>
        <option value="Karyawan">Karyawan</option>
        <option value="Kontraktor">Kontraktor</option>
        <option value="Orang Luar">Orang Luar</option>
      </select>
    </div>
    <div class="form-row">
      <label for="masa_kerja_jabatan">Masa Kerja Jabatan Terakhir</label>
      <input type="number" name="masa_kerja_jabatan" id="masa_kerja_jabatan" placeholder="tahun">
    </div>
    <div class="form-row">
      <label for="foto">Upload Foto</label>
      <input type="file" name="foto" id="foto" accept="image/*">
    </div>
    <div class="form-row">
      <button type="submit" class="btn-primary">Kirim Laporan</button>
    </div>
  </form>
</div>
<?php include '../includes/footer.php'; ?>