<?php
session_start();
include '../includes/header.php';
include '../config/db.php';

$error = '';
$user = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // Mengambil data user berdasarkan username
    $sql = "SELECT * FROM users WHERE username = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $username);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $user = mysqli_fetch_assoc($result);

    if ($user && $password === $user['password']) {
        $_SESSION['user'] = [
            'id' => $user['id'],
            'username' => $user['username'],
            'role' => $user['role'],
            'name' => $user['name']
        ];

        // Redirect sesuai role
        if ($user['role'] === 'admin') {
            header('Location: ../admin/index.php');
        } elseif ($user['role'] === 'petugas') {
            header('Location: ../petugas/index.php');
        } elseif ($user['role'] === 'supervisor') {
            header('Location: ../supervisor/index.php');
        } else {
            header('Location: dashboard.php');
        }
        exit;
    } else {
        $error = "Username atau password salah.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8"><title>Login</title>
</head>
<body>
    <h2>Login</h2>
    <?php if($error): ?><p style="color:red;"><?= htmlspecialchars($error) ?></p><?php endif; ?>
    <form method="post">
        <label>Username: <input type="text" name="username" required></label><br>
        <label>Password: <input type="password" name="password" required></label><br>
        <button type="submit">Login</button>
    </form>
    <p><a href="index.php">Kembali ke Beranda</a></p>
</body>
</html>