<?php
include '../includes/header.php';
include '../includes/navbar.php';
include '../config/db.php';
?>
<style>
.panduan-container {
    max-width: 900px;
    margin: 30px auto;
    padding: 30px 0;
}
.panduan-title {
    text-align: center;
    font-size: 2rem;
    font-weight: bold;
    margin-bottom: 8px;
}
.panduan-subtitle {
    text-align: center;
    color: #666;
    margin-bottom: 24px;
    font-size: 1.1rem;
}
.panduan-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 32px;
}
.panduan-card {
    background: #fff;
    border-radius: 18px;
    box-shadow: 0 2px 16px rgba(0,0,0,.06);
    padding: 32px 22px;
    min-height: 150px;
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    transition: box-shadow .2s;
    border: 1px solid #f4f4f4;
}
.panduan-card:hover {
    box-shadow: 0 4px 24px rgba(0,0,0,.10);
}
.panduan-icon {
    font-size: 2.4rem;
    margin-bottom: 10px;
    display: inline-block;
}
.panduan-card h4 {
    margin: 0 0 6px 0;
    font-size: 1.1rem;
}
.panduan-card p {
    margin: 0;
    color: #444;
    font-size: 0.97rem;
}
</style>
<div class="panduan-container">
    <div class="panduan-title">Panduan Keselamatan Kerja</div>
    <div class="panduan-subtitle">
        Ikuti panduan K3 untuk menciptakan lingkungan kerja yang aman dan produktif
    </div>
    <div class="panduan-grid">
        <?php
        // Kaitkan icon sesuai contoh, bisa dengan Unicode atau SVG inline, atau icon font jika sudah tersedia
        $iconClass = [
            'Gunakan APD' => '<span class="panduan-icon" style="color: #53A4F3">&#128096;</span>', // Shoes icon unicode
            'Laporkan Bahaya' => '<span class="panduan-icon" style="color: #FFBD5C">&#9888;</span>', // Warning icon
            'Waspada' => '<span class="panduan-icon" style="color: #A184FD">&#128065;</span>', // Eye icon
            'Pertolongan Pertama' => '<span class="panduan-icon" style="color: #FF8D8C">&#10084;</span>', // Heart icon
            'Prosedur Darurat' => '<span class="panduan-icon" style="color: #FFD34F">&#9889;</span>', // Thunder icon
            'Pelatihan Rutin' => '<span class="panduan-icon" style="color: #4ADE80">&#128274;</span>', // Shield icon
        ];
        $result = mysqli_query($conn, "SELECT * FROM panduan");
        while ($row = mysqli_fetch_assoc($result)) {
            $judul = $row['judul'];
            $isi = $row['isi'];
            $icon = isset($iconClass[$judul]) ? $iconClass[$judul] : '';
            echo "
            <div class='panduan-card'>
                $icon
                <h4>$judul</h4>
                <p>$isi</p>
            </div>";
        }
        ?>
    </div>
</div>
<?php
include '../includes/footer.php';
?>