<?php
include '../includes/header.php';
include '../includes/navbar.php';
include '../config/db.php';

if (!$conn) {
    die("Koneksi database gagal.");
}

$statistik = [];
$q = mysqli_query($conn, "SELECT MONTH(tanggal) AS bulan, COUNT(*) AS total FROM laporan GROUP BY bulan");
while ($row = mysqli_fetch_assoc($q)) {
    $statistik[$row['bulan']] = $row['total'];
}
?>

<h2>Grafik Insiden Bulanan</h2>
<canvas id="chartInsiden"></canvas>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('chartInsiden').getContext('2d');
const chart = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: <?= json_encode(array_keys($statistik)) ?>,
        datasets: [{
            label: 'Jumlah Insiden',
            data: <?= json_encode(array_values($statistik)) ?>,
            backgroundColor: 'rgba(255,99,132,0.2)',
            borderColor: 'rgba(255,99,132,1)',
            borderWidth: 1
        }]
    },
    options: {
        scales: { y: { beginAtZero: true } }
    }
});
</script>

<?php include '../includes/footer.php'; ?>
