<?php
session_start();
include '../config/db.php';
include '../includes/header.php';
include '../includes/navbar.php';

$user = $_SESSION['user'] ?? null;
if (!$user || $user['role'] !== 'supervisor') {
    header("Location: ../public/login.php");
    exit();
}

// Ambil data laporan dari database
$query = "SELECT * FROM laporan";
$result = mysqli_query($conn, $query);

// Hitung jumlah berdasarkan status untuk supervisor
$menungguApproval = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM laporan WHERE status = 'Menunggu Approval'"));
$closed = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM laporan WHERE status = 'Closed'"));
$totalReviewed = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM laporan WHERE status IN ('Menunggu Approval','Closed')"));
?>

<div class="container mt-4">
    <h4>Dashboard Supervisor/Manajer</h4>
    <p>Review hasil investigasi dan berikan persetujuan akhir laporan</p>

    <!-- Statistik Ringkas dengan border warna -->
    <div class="row mb-4">
        <div class="col-md-4 mb-2 mb-md-0">
            <div class="card text-center p-3 shadow-sm" style="border:2px solid #b6d0f7;">
                <p class="mb-1 fw-bold">Menunggu Approval</p>
                <h3><?= $menungguApproval ?></h3>
            </div>
        </div>
        <div class="col-md-4 mb-2 mb-md-0">
            <div class="card text-center p-3 shadow-sm" style="border:2px solid #9199b4;">
                <p class="mb-1 fw-bold">Sudah Closed</p>
                <h3><?= $closed ?></h3>
            </div>
        </div>
        <div class="col-md-4 mb-2 mb-md-0">
            <div class="card text-center p-3 shadow-sm" style="border:2px solid #b3ecd5;">
                <p class="mb-1 fw-bold">Total Reviewed</p>
                <h3><?= $totalReviewed ?></h3>
            </div>
        </div>
    </div>

    <!-- Tabel Laporan -->
    <div class="card p-3 shadow-sm">
        <div class="d-flex mb-2">
            <!-- Tabs Status -->
            <nav class="nav nav-tabs border-0 flex-row">
                <a class="nav-link fw-bold <?= (!isset($_GET['tab'])||$_GET['tab']=='menunggu')?'active text-primary':'' ?>" href="#">Menunggu Approval (<?= $menungguApproval ?>)</a>
                <a class="nav-link fw-bold <?= (isset($_GET['tab'])&&$_GET['tab']=='closed')?'active text-primary':'' ?>" href="#">Closed (<?= $closed ?>)</a>
            </nav>
            <!-- Filter & Export Button -->
            <div class="ms-auto d-flex gap-2">
                <button class="btn btn-light border"><i class="bi bi-funnel"></i> Filter</button>
                <button class="btn btn-light border"><i class="bi bi-download"></i> Export</button>
            </div>
        </div>

        <!-- Tabel Data -->
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Tanggal</th>
                        <th>Pelapor</th>
                        <th>Dept</th>
                        <th>Jenis</th>
                        <th>Tingkat</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)) : 
                        // Filter tab
                        $tab = $_GET['tab'] ?? 'menunggu';
                        if (
                            ($tab == 'menunggu' && $row['status'] != 'Menunggu Approval') ||
                            ($tab == 'closed' && $row['status'] != 'Closed')
                        ) continue;
                    ?>
                        <tr>
                            <td><?= htmlspecialchars($row['id']) ?></td>
                            <td><?= date('d M Y', strtotime($row['tanggal'])) ?></td>
                            <td>
                                <?= htmlspecialchars($row['pelapor_id']) ?>
                            </td>
                            <td><?= htmlspecialchars($row['lokasi']) ?></td>
                            <td><?= htmlspecialchars($row['judul']) ?></td>
                            <td>
                                <?php
                                $tingkat = strtolower($row['tingkat_risiko'] ?? '');
                                if ($tingkat == 'rendah') {
                                    echo '<span class="badge bg-success-subtle text-success">Rendah</span>';
                                } elseif ($tingkat == 'sedang') {
                                    echo '<span class="badge bg-warning-subtle text-warning">Sedang</span>';
                                } elseif ($tingkat == 'tinggi') {
                                    echo '<span class="badge bg-danger-subtle text-danger">Tinggi</span>';
                                } else {
                                    echo '-';
                                }
                                ?>
                            </td>
                            <td>
                                <?php
                                if ($row['status'] == 'Menunggu Approval') {
                                    echo '<span class="badge bg-info-subtle text-primary">Menunggu Approval</span>';
                                } elseif ($row['status'] == 'Closed') {
                                    echo '<span class="badge bg-secondary-subtle text-dark">Closed</span>';
                                } else {
                                    echo htmlspecialchars($row['status']);
                                }
                                ?>
                            </td>
                            <td>
                                <a href="detail_laporan.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-link text-decoration-none px-2"><i class="bi bi-eye"></i> Detail</a>
                                <?php if ($row['status'] == 'Menunggu Approval'): ?>
                                    <a href="approve.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-link text-success px-2"><i class="bi bi-hand-thumbs-up"></i> Approve</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include '../includes/footer.php'; ?>